/*
   This program starts a child process and wants to redirect
   the child's stdin to a file and redirect the child's stdout
   to a file. But this cannot be done in Java 6 (or earlier).
   So we fake it (in a really dumb way).

   In this program, the parent reads one line from the input
   file, writes that line to the child's stdin, then the parent
   goes to the "other end" of the child process and reads one
   line from the child's stdout and wrties that line to the
   output file. This helps, but it does NOT eliminate the
   problem of deadlock!


   Important: Notice that this program is logically the
   same as the following command line.

   C:\> java Double < L200.txt > result.txt

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection before
   running the program Double.class. In the case of this
   program, the program itself does the I/O redirection
   for its child.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_RedirectChildStdinStdoutToFiles_ver2
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the child.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      // Create a stream that writes data to the child's stdin stream.
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );
      // Create a stream that reads data from the child's stdout stream.
      Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a stream that reads data from the input file.
      Scanner inputFile = new Scanner( new FileInputStream( "L200.txt" ) );
      // Create a stream that writes data to the output file.
      PrintStream outputFile =  new PrintStream( new FileOutputStream( "result.txt" ) );

      // Copy one line at a time from the input file into the child's stdin,
      // and then copy that line from the child's stdout into the output file.
      while ( inputFile.hasNextLine() )
      {
         String oneLine1 = inputFile.nextLine();     // read a line from the input file
         stdinOfChild.println( oneLine1 );           // send it to the child's stdin
         stdinOfChild.flush();  //THIS IS IMPORTANT (otherwise, the parent will just hang)
         String oneLine2 = stdoutOfChild.nextLine(); // wait for the child to process the line
         outputFile.println( oneLine2 );             // write resulting line to the output file
      }

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
      stdinOfChild.close();
      outputFile.close();
   }
}

/*
   IMPORTANT:
   Explain why this program will hang, and never terminate,
   if the child process is the program MakeOneLine.java.
*/